/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.wuzhizhan.mybatis.dom.model.Configuration;
import com.wuzhizhan.mybatis.dom.model.IdDomElement;
import com.wuzhizhan.mybatis.dom.model.Mapper;
import com.wuzhizhan.mybatis.dom.model.Package;
import com.wuzhizhan.mybatis.dom.model.TypeAlias;
import com.wuzhizhan.mybatis.dom.model.TypeAliases;
import com.wuzhizhan.mybatis.util.CollectionUtils;
import com.wuzhizhan.mybatis.util.DomUtils;
import com.wuzhizhan.mybatis.util.JavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapperUtils {
    private MapperUtils() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Optional<IdDomElement> findParentIdDomElement(@Nullable PsiElement element) {
        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
        if (null == domElement) {
            Optional<IdDomElement> optional = Optional.empty();
            if (optional == null) {
                MapperUtils.$$$reportNull$$$0(0);
            }
            return optional;
        }
        if (domElement instanceof IdDomElement) {
            Optional<IdDomElement> optional = Optional.of((IdDomElement)domElement);
            if (optional == null) {
                MapperUtils.$$$reportNull$$$0(1);
            }
            return optional;
        }
        Optional<IdDomElement> optional = Optional.ofNullable((IdDomElement)DomUtil.getParentOfType((DomElement)domElement, IdDomElement.class, (boolean)true));
        if (optional == null) {
            MapperUtils.$$$reportNull$$$0(2);
        }
        return optional;
    }

    public static PsiElement createMapperFromFileTemplate(@NotNull String fileTemplateName, @NotNull String fileName, @NotNull PsiDirectory directory, @Nullable Properties pops) throws Exception {
        if (fileTemplateName == null) {
            MapperUtils.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            MapperUtils.$$$reportNull$$$0(4);
        }
        if (directory == null) {
            MapperUtils.$$$reportNull$$$0(5);
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance().getJ2eeTemplate(fileTemplateName);
        return FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)fileName, (Properties)pops, (PsiDirectory)directory);
    }

    @NotNull
    public static Collection<PsiDirectory> findMapperDirectories(@NotNull Project project) {
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(6);
        }
        Collection collection = Collections2.transform(MapperUtils.findMappers(project), (Function)new Function<Mapper, PsiDirectory>(){

            public PsiDirectory apply(Mapper input) {
                return input.getXmlElement().getContainingFile().getContainingDirectory();
            }
        });
        if (collection == null) {
            MapperUtils.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public static boolean isElementWithinMybatisFile(@NotNull PsiElement element) {
        if (element == null) {
            MapperUtils.$$$reportNull$$$0(8);
        }
        PsiFile psiFile = element.getContainingFile();
        return element instanceof XmlElement && DomUtils.isMybatisFile(psiFile);
    }

    @NotNull
    @NonNls
    public static Collection<Mapper> findMappers(@NotNull Project project) {
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(9);
        }
        Collection<Mapper> collection = DomUtils.findDomElements(project, Mapper.class);
        if (collection == null) {
            MapperUtils.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    @NonNls
    public static Collection<Mapper> findMappers(@NotNull Project project, @NotNull String namespace) {
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(11);
        }
        if (namespace == null) {
            MapperUtils.$$$reportNull$$$0(12);
        }
        ArrayList result = Lists.newArrayList();
        for (Mapper mapper : MapperUtils.findMappers(project)) {
            if (!MapperUtils.getNamespace(mapper).equals(namespace)) continue;
            result.add(mapper);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            MapperUtils.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<Mapper> findMappers(@NotNull Project project, @NotNull PsiClass clazz) {
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(14);
        }
        if (clazz == null) {
            MapperUtils.$$$reportNull$$$0(15);
        }
        Collection<Mapper> collection = JavaUtils.isElementWithinInterface((PsiElement)clazz) ? MapperUtils.findMappers(project, clazz.getQualifiedName()) : Collections.emptyList();
        if (collection == null) {
            MapperUtils.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static Collection<Mapper> findMappers(@NotNull Project project, @NotNull PsiMethod method) {
        PsiClass clazz;
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(17);
        }
        if (method == null) {
            MapperUtils.$$$reportNull$$$0(18);
        }
        return null == (clazz = method.getContainingClass()) ? Collections.emptyList() : MapperUtils.findMappers(project, clazz);
    }

    @NotNull
    @NonNls
    public static Optional<Mapper> findFirstMapper(@NotNull Project project, @NotNull String namespace) {
        Collection<Mapper> mappers;
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(19);
        }
        if (namespace == null) {
            MapperUtils.$$$reportNull$$$0(20);
        }
        Optional<Mapper> optional = CollectionUtils.isEmpty(mappers = MapperUtils.findMappers(project, namespace)) ? Optional.empty() : Optional.of(mappers.iterator().next());
        if (optional == null) {
            MapperUtils.$$$reportNull$$$0(21);
        }
        return optional;
    }

    @NotNull
    @NonNls
    public static Optional<Mapper> findFirstMapper(@NotNull Project project, @NotNull PsiClass clazz) {
        String qualifiedName;
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(22);
        }
        if (clazz == null) {
            MapperUtils.$$$reportNull$$$0(23);
        }
        Optional<Mapper> optional = null != (qualifiedName = clazz.getQualifiedName()) ? MapperUtils.findFirstMapper(project, qualifiedName) : Optional.empty();
        if (optional == null) {
            MapperUtils.$$$reportNull$$$0(24);
        }
        return optional;
    }

    @NotNull
    @NonNls
    public static Optional<Mapper> findFirstMapper(@NotNull Project project, @NotNull PsiMethod method) {
        PsiClass containingClass;
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(25);
        }
        if (method == null) {
            MapperUtils.$$$reportNull$$$0(26);
        }
        Optional<Mapper> optional = null != (containingClass = method.getContainingClass()) ? MapperUtils.findFirstMapper(project, containingClass) : Optional.empty();
        if (optional == null) {
            MapperUtils.$$$reportNull$$$0(27);
        }
        return optional;
    }

    @NotNull
    @NonNls
    public static Mapper getMapper(@NotNull DomElement element) {
        Optional<Mapper> optional;
        if (element == null) {
            MapperUtils.$$$reportNull$$$0(28);
        }
        if ((optional = Optional.ofNullable((Mapper)DomUtil.getParentOfType((DomElement)element, Mapper.class, (boolean)true))).isPresent()) {
            Mapper mapper = optional.get();
            if (mapper == null) {
                MapperUtils.$$$reportNull$$$0(29);
            }
            return mapper;
        }
        throw new IllegalArgumentException("Unknown element");
    }

    @NotNull
    @NonNls
    public static String getNamespace(@NotNull Mapper mapper) {
        String ns;
        if (mapper == null) {
            MapperUtils.$$$reportNull$$$0(30);
        }
        String string = null == (ns = mapper.getNamespace().getStringValue()) ? "" : ns;
        if (string == null) {
            MapperUtils.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getNamespace(@NotNull DomElement element) {
        if (element == null) {
            MapperUtils.$$$reportNull$$$0(32);
        }
        return MapperUtils.getNamespace(MapperUtils.getMapper(element));
    }

    @NonNls
    public static boolean isMapperWithSameNamespace(@Nullable Mapper mapper, @Nullable Mapper target) {
        return null != mapper && null != target && MapperUtils.getNamespace(mapper).equals(MapperUtils.getNamespace(target));
    }

    @Nullable
    @NonNls
    public static <T extends IdDomElement> String getId(@NotNull T domElement) {
        if (domElement == null) {
            MapperUtils.$$$reportNull$$$0(33);
        }
        return domElement.getId().getRawText();
    }

    @NotNull
    @NonNls
    public static <T extends IdDomElement> String getIdSignature(@NotNull T domElement) {
        if (domElement == null) {
            MapperUtils.$$$reportNull$$$0(34);
        }
        String string = MapperUtils.getNamespace(domElement) + "." + MapperUtils.getId(domElement);
        if (string == null) {
            MapperUtils.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static <T extends IdDomElement> String getIdSignature(@NotNull T domElement, @NotNull Mapper mapper) {
        if (domElement == null) {
            MapperUtils.$$$reportNull$$$0(36);
        }
        if (mapper == null) {
            MapperUtils.$$$reportNull$$$0(37);
        }
        Mapper contextMapper = MapperUtils.getMapper(domElement);
        String id = MapperUtils.getId(domElement);
        if (id == null) {
            id = "";
        }
        String idsignature = MapperUtils.getIdSignature(domElement);
        String string = MapperUtils.isMapperWithSameNamespace(contextMapper, mapper) ? id : idsignature;
        if (string == null) {
            MapperUtils.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static void processConfiguredTypeAliases(@NotNull Project project, @NotNull Processor<TypeAlias> processor) {
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            MapperUtils.$$$reportNull$$$0(40);
        }
        for (Configuration conf : MapperUtils.getMybatisConfigurations(project)) {
            for (TypeAliases tas : conf.getTypeAliases()) {
                for (TypeAlias ta : tas.getTypeAlias()) {
                    String stringValue = ta.getAlias().getStringValue();
                    if (null == stringValue || processor.process((Object)ta)) continue;
                    return;
                }
            }
        }
    }

    private static Collection<Configuration> getMybatisConfigurations(Project project) {
        return DomUtils.findDomElements(project, Configuration.class);
    }

    public static void processConfiguredPackage(@NotNull Project project, @NotNull Processor<Package> processor) {
        if (project == null) {
            MapperUtils.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            MapperUtils.$$$reportNull$$$0(42);
        }
        for (Configuration conf : MapperUtils.getMybatisConfigurations(project)) {
            for (TypeAliases tas : conf.getTypeAliases()) {
                for (Package pkg : tas.getPackages()) {
                    if (processor.process((Object)pkg)) continue;
                    return;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/util/MapperUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTemplateName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findParentIdDomElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/util/MapperUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMapperDirectories";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findMappers";
                break;
            }
            case 21: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstMapper";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapper";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdSignature";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMapperFromFileTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMapperDirectories";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isElementWithinMybatisFile";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findMappers";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findFirstMapper";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMapper";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIdSignature";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processConfiguredTypeAliases";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processConfiguredPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

