/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.wuzhizhan.mybatis.annotation.Annotation;
import com.wuzhizhan.mybatis.dom.model.IdDomElement;
import com.wuzhizhan.mybatis.util.MapperUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaUtils {
    private JavaUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isModelClazz(@Nullable PsiClass clazz) {
        return null != clazz && !clazz.isAnnotationType() && !clazz.isInterface() && !clazz.isEnum() && clazz.isValid();
    }

    @NotNull
    public static Optional<PsiField> findSettablePsiField(@NotNull PsiClass clazz, @Nullable String propertyName) {
        PsiField field;
        if (clazz == null) {
            JavaUtils.$$$reportNull$$$0(0);
        }
        Optional<Object> optional = (field = PropertyUtil.findPropertyField((PsiClass)clazz, (String)propertyName, (boolean)false)) != null ? Optional.of(field) : Optional.empty();
        if (optional == null) {
            JavaUtils.$$$reportNull$$$0(1);
        }
        return optional;
    }

    @NotNull
    public static PsiField[] findSettablePsiFields(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JavaUtils.$$$reportNull$$$0(2);
        }
        PsiField[] fields = clazz.getAllFields();
        ArrayList<PsiField> settableFields = new ArrayList<PsiField>(fields.length);
        for (PsiField f : fields) {
            PsiModifierList modifiers = f.getModifierList();
            if (modifiers != null && (modifiers.hasModifierProperty("static") || modifiers.hasModifierProperty("final"))) continue;
            settableFields.add(f);
        }
        PsiField[] psiFieldArray = settableFields.toArray(new PsiField[0]);
        if (psiFieldArray == null) {
            JavaUtils.$$$reportNull$$$0(3);
        }
        return psiFieldArray;
    }

    public static boolean isElementWithinInterface(@Nullable PsiElement element) {
        if (element instanceof PsiClass && ((PsiClass)element).isInterface()) {
            return true;
        }
        PsiClass type = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        return Optional.ofNullable(type).isPresent() && type.isInterface();
    }

    @NotNull
    public static Optional<PsiClass> findClazz(@NotNull Project project, @NotNull String clazzName) {
        if (project == null) {
            JavaUtils.$$$reportNull$$$0(4);
        }
        if (clazzName == null) {
            JavaUtils.$$$reportNull$$$0(5);
        }
        Optional<PsiClass> optional = Optional.ofNullable(JavaPsiFacade.getInstance((Project)project).findClass(clazzName, GlobalSearchScope.allScope((Project)project)));
        if (optional == null) {
            JavaUtils.$$$reportNull$$$0(6);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiMethod> findMethod(@NotNull Project project, @Nullable String clazzName, @Nullable String methodName) {
        if (project == null) {
            JavaUtils.$$$reportNull$$$0(7);
        }
        if (StringUtils.isBlank((String)clazzName) && StringUtils.isBlank((String)methodName)) {
            Optional<PsiMethod> optional = Optional.empty();
            if (optional == null) {
                JavaUtils.$$$reportNull$$$0(8);
            }
            return optional;
        }
        Optional<PsiClass> clazz = JavaUtils.findClazz(project, clazzName);
        if (clazz.isPresent()) {
            Object[] methods = clazz.get().findMethodsByName(methodName, true);
            Optional<Object> optional = ArrayUtils.isEmpty((Object[])methods) ? Optional.empty() : Optional.of(methods[0]);
            if (optional == null) {
                JavaUtils.$$$reportNull$$$0(9);
            }
            return optional;
        }
        Optional<PsiMethod> optional = Optional.empty();
        if (optional == null) {
            JavaUtils.$$$reportNull$$$0(10);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiMethod> findMethod(@NotNull Project project, @NotNull IdDomElement element) {
        if (project == null) {
            JavaUtils.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JavaUtils.$$$reportNull$$$0(12);
        }
        return JavaUtils.findMethod(project, MapperUtils.getNamespace(element), MapperUtils.getId(element));
    }

    public static boolean isAnnotationPresent(@NotNull PsiModifierListOwner target, @NotNull Annotation annotation) {
        PsiModifierList modifierList;
        if (target == null) {
            JavaUtils.$$$reportNull$$$0(13);
        }
        if (annotation == null) {
            JavaUtils.$$$reportNull$$$0(14);
        }
        return null != (modifierList = target.getModifierList()) && null != modifierList.findAnnotation(annotation.getQualifiedName());
    }

    @NotNull
    public static Optional<PsiAnnotation> getPsiAnnotation(@NotNull PsiModifierListOwner target, @NotNull Annotation annotation) {
        PsiModifierList modifierList;
        if (target == null) {
            JavaUtils.$$$reportNull$$$0(15);
        }
        if (annotation == null) {
            JavaUtils.$$$reportNull$$$0(16);
        }
        Optional<PsiAnnotation> optional = null == (modifierList = target.getModifierList()) ? Optional.empty() : Optional.ofNullable(modifierList.findAnnotation(annotation.getQualifiedName()));
        if (optional == null) {
            JavaUtils.$$$reportNull$$$0(17);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiAnnotationMemberValue> getAnnotationAttributeValue(@NotNull PsiModifierListOwner target, @NotNull Annotation annotation, @NotNull String attrName) {
        if (target == null) {
            JavaUtils.$$$reportNull$$$0(18);
        }
        if (annotation == null) {
            JavaUtils.$$$reportNull$$$0(19);
        }
        if (attrName == null) {
            JavaUtils.$$$reportNull$$$0(20);
        }
        if (!JavaUtils.isAnnotationPresent(target, annotation)) {
            Optional<PsiAnnotationMemberValue> optional = Optional.empty();
            if (optional == null) {
                JavaUtils.$$$reportNull$$$0(21);
            }
            return optional;
        }
        Optional<PsiAnnotation> psiAnnotation = JavaUtils.getPsiAnnotation(target, annotation);
        Optional<PsiAnnotationMemberValue> optional = psiAnnotation.isPresent() ? Optional.ofNullable(psiAnnotation.get().findAttributeValue(attrName)) : Optional.empty();
        if (optional == null) {
            JavaUtils.$$$reportNull$$$0(22);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiAnnotationMemberValue> getAnnotationValue(@NotNull PsiModifierListOwner target, @NotNull Annotation annotation) {
        if (target == null) {
            JavaUtils.$$$reportNull$$$0(23);
        }
        if (annotation == null) {
            JavaUtils.$$$reportNull$$$0(24);
        }
        return JavaUtils.getAnnotationAttributeValue(target, annotation, "value");
    }

    public static Optional<String> getAnnotationValueText(@NotNull PsiModifierListOwner target, @NotNull Annotation annotation) {
        Optional<PsiAnnotationMemberValue> annotationValue;
        if (target == null) {
            JavaUtils.$$$reportNull$$$0(25);
        }
        if (annotation == null) {
            JavaUtils.$$$reportNull$$$0(26);
        }
        return (annotationValue = JavaUtils.getAnnotationValue(target, annotation)).isPresent() ? Optional.of(annotationValue.get().getText().replaceAll("\"", "")) : Optional.empty();
    }

    public static boolean isAnyAnnotationPresent(@NotNull PsiModifierListOwner target, @NotNull Set<Annotation> annotations) {
        if (target == null) {
            JavaUtils.$$$reportNull$$$0(27);
        }
        if (annotations == null) {
            JavaUtils.$$$reportNull$$$0(28);
        }
        for (Annotation annotation : annotations) {
            if (!JavaUtils.isAnnotationPresent(target, annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllParameterWithAnnotation(@NotNull PsiMethod method, @NotNull Annotation annotation) {
        PsiParameter[] parameters;
        if (method == null) {
            JavaUtils.$$$reportNull$$$0(29);
        }
        if (annotation == null) {
            JavaUtils.$$$reportNull$$$0(30);
        }
        for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
            if (JavaUtils.isAnnotationPresent((PsiModifierListOwner)parameter, annotation)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasImportClazz(@NotNull PsiJavaFile file, @NotNull String clazzName) {
        PsiImportStatement[] statements;
        PsiImportList importList;
        if (file == null) {
            JavaUtils.$$$reportNull$$$0(31);
        }
        if (clazzName == null) {
            JavaUtils.$$$reportNull$$$0(32);
        }
        if (null == (importList = file.getImportList())) {
            return false;
        }
        for (PsiImportStatement tmp : statements = importList.getImportStatements()) {
            if (null == tmp || !tmp.getQualifiedName().equals(clazzName)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/util/JavaUtils";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazzName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/util/JavaUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findSettablePsiField";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findSettablePsiFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findClazz";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethod";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiAnnotation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationAttributeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSettablePsiField";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 21: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSettablePsiFields";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClazz";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationPresent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPsiAnnotation";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttributeValue";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValue";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValueText";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAnyAnnotationPresent";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAllParameterWithAnnotation";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasImportClazz";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

