/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomUtils {
    private DomUtils() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    @NonNls
    public static <T extends DomElement> Collection<T> findDomElements(@NotNull Project project, Class<T> clazz) {
        if (project == null) {
            DomUtils.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        List elements = DomService.getInstance().getFileElements(clazz, project, scope);
        Collection collection = Collections2.transform((Collection)elements, (Function)new Function<DomFileElement<T>, T>(){

            public T apply(DomFileElement<T> input) {
                return input.getRootElement();
            }
        });
        if (collection == null) {
            DomUtils.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public static boolean isMybatisFile(@Nullable PsiFile file) {
        if (!DomUtils.isXmlFile(file)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        return null != rootTag && rootTag.getName().equals("mapper");
    }

    public static boolean isMybatisConfigurationFile(@NotNull PsiFile file) {
        if (file == null) {
            DomUtils.$$$reportNull$$$0(2);
        }
        if (!DomUtils.isXmlFile(file)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        return null != rootTag && rootTag.getName().equals("configuration");
    }

    public static boolean isBeansFile(@NotNull PsiFile file) {
        if (file == null) {
            DomUtils.$$$reportNull$$$0(3);
        }
        if (!DomUtils.isXmlFile(file)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        return null != rootTag && rootTag.getName().equals("beans");
    }

    static boolean isXmlFile(@NotNull PsiFile file) {
        if (file == null) {
            DomUtils.$$$reportNull$$$0(4);
        }
        return file instanceof XmlFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/util/DomUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/util/DomUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findDomElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDomElements";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMybatisConfigurationFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBeansFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isXmlFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

