/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.wuzhizhan.mybatis.ui.ClickableListener;
import com.wuzhizhan.mybatis.ui.ExecutableListener;
import com.wuzhizhan.mybatis.ui.ListSelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UiComponentFacade {
    private Project project;
    private FileEditorManager fileEditorManager;

    private UiComponentFacade(Project project) {
        this.project = project;
        this.fileEditorManager = FileEditorManager.getInstance((Project)project);
    }

    public static UiComponentFacade getInstance(@NotNull Project project) {
        if (project == null) {
            UiComponentFacade.$$$reportNull$$$0(0);
        }
        return new UiComponentFacade(project);
    }

    public VirtualFile showSingleFolderSelectionDialog(@NotNull String title, @Nullable VirtualFile toSelect, VirtualFile ... roots) {
        if (title == null) {
            UiComponentFacade.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(title);
        if (null != roots) {
            descriptor.setRoots(roots);
        }
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.project, (VirtualFile)toSelect);
    }

    public JBPopup showListPopupWithSingleClickable(@NotNull String popupTitle, @NotNull ListSelectionListener popupListener, @NotNull String clickableTitle, final @Nullable ClickableListener clickableListener, @NotNull Object[] objs) {
        if (popupTitle == null) {
            UiComponentFacade.$$$reportNull$$$0(2);
        }
        if (popupListener == null) {
            UiComponentFacade.$$$reportNull$$$0(3);
        }
        if (clickableTitle == null) {
            UiComponentFacade.$$$reportNull$$$0(4);
        }
        if (objs == null) {
            UiComponentFacade.$$$reportNull$$$0(5);
        }
        PopupChooserBuilder builder = this.createListPopupBuilder(popupTitle, popupListener, objs);
        JBCheckBox checkBox = new JBCheckBox(clickableTitle);
        builder.setSouthComponent((JComponent)checkBox);
        final JBPopup popup = builder.createPopup();
        if (null != clickableListener) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    clickableListener.clicked();
                }
            };
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popup.dispose();
                    UiComponentFacade.this.setActionForExecutableListener(runnable, clickableListener);
                }
            });
        }
        this.setPositionForShown(popup);
        return popup;
    }

    public JBPopup showListPopup(@NotNull String title, @Nullable ListSelectionListener listener, @NotNull Object[] objs) {
        if (title == null) {
            UiComponentFacade.$$$reportNull$$$0(6);
        }
        if (objs == null) {
            UiComponentFacade.$$$reportNull$$$0(7);
        }
        PopupChooserBuilder builder = this.createListPopupBuilder(title, listener, objs);
        JBPopup popup = builder.createPopup();
        this.setPositionForShown(popup);
        return popup;
    }

    private void setPositionForShown(JBPopup popup) {
        Editor editor = this.fileEditorManager.getSelectedTextEditor();
        if (null != editor) {
            popup.showInBestPositionFor(editor);
        } else {
            popup.showCenteredInCurrentWindow(this.project);
        }
    }

    private void setActionForExecutableListener(Runnable runnable, ExecutableListener listener) {
        Application application = ApplicationManager.getApplication();
        if (listener.isWriteAction()) {
            application.runWriteAction(runnable);
        } else {
            application.runReadAction(runnable);
        }
    }

    public PopupChooserBuilder createListPopupBuilder(@NotNull String title, final @Nullable ListSelectionListener listener, Object ... objs) {
        if (title == null) {
            UiComponentFacade.$$$reportNull$$$0(8);
        }
        if (objs == null) {
            UiComponentFacade.$$$reportNull$$$0(9);
        }
        final JBList list = new JBList(objs);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        builder.setTitle(title);
        if (null != listener) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    listener.selected(list.getSelectedIndex());
                }
            };
            builder.setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    UiComponentFacade.this.setActionForExecutableListener(runnable, listener);
                }
            });
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickableTitle";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objs";
                break;
            }
        }
        objectArray2[1] = "com/wuzhizhan/mybatis/ui/UiComponentFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showSingleFolderSelectionDialog";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showListPopupWithSingleClickable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showListPopup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createListPopupBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

