/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.setting;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.wuzhizhan.mybatis.generate.GenerateModel;
import com.wuzhizhan.mybatis.generate.StatementGenerator;
import java.lang.reflect.Type;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="MybatisSettings", storages={@Storage(file="$APP_CONFIG$/mybatis.xml")})
public class MybatisSetting
implements PersistentStateComponent<Element> {
    private GenerateModel statementGenerateModel;
    private Gson gson = new Gson();
    private Type gsonTypeToken = new TypeToken<Set<String>>(){}.getType();

    public MybatisSetting() {
        this.statementGenerateModel = GenerateModel.START_WITH_MODEL;
    }

    public static MybatisSetting getInstance() {
        return (MybatisSetting)ServiceManager.getService(MybatisSetting.class);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("MybatisSettings");
        element.setAttribute(StatementGenerator.INSERT_GENERATOR.getId(), this.gson.toJson(StatementGenerator.INSERT_GENERATOR.getPatterns()));
        element.setAttribute(StatementGenerator.DELETE_GENERATOR.getId(), this.gson.toJson(StatementGenerator.DELETE_GENERATOR.getPatterns()));
        element.setAttribute(StatementGenerator.UPDATE_GENERATOR.getId(), this.gson.toJson(StatementGenerator.UPDATE_GENERATOR.getPatterns()));
        element.setAttribute(StatementGenerator.SELECT_GENERATOR.getId(), this.gson.toJson(StatementGenerator.SELECT_GENERATOR.getPatterns()));
        element.setAttribute("statementGenerateModel", String.valueOf(this.statementGenerateModel.getIdentifier()));
        return element;
    }

    public void loadState(Element state) {
        this.loadState(state, StatementGenerator.INSERT_GENERATOR);
        this.loadState(state, StatementGenerator.DELETE_GENERATOR);
        this.loadState(state, StatementGenerator.UPDATE_GENERATOR);
        this.loadState(state, StatementGenerator.SELECT_GENERATOR);
        this.statementGenerateModel = GenerateModel.getInstance(state.getAttributeValue("statementGenerateModel"));
    }

    private void loadState(Element state, StatementGenerator generator) {
        String attribute = state.getAttributeValue(generator.getId());
        if (null != attribute) {
            generator.setPatterns((Set)this.gson.fromJson(attribute, this.gsonTypeToken));
        }
    }

    public GenerateModel getStatementGenerateModel() {
        return this.statementGenerateModel;
    }

    public void setStatementGenerateModel(GenerateModel statementGenerateModel) {
        this.statementGenerateModel = statementGenerateModel;
    }
}

