/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.setting;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.wuzhizhan.mybatis.generate.GenerateModel;
import com.wuzhizhan.mybatis.generate.StatementGenerator;
import com.wuzhizhan.mybatis.setting.MybatisSetting;
import com.wuzhizhan.mybatis.setting.MybatisSettingForm;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class MybatisConfigurable
implements SearchableConfigurable {
    private MybatisSetting mybatisSetting;
    private MybatisSettingForm mybatisSettingForm;
    private String separator = ";";
    private Splitter splitter = Splitter.on((String)this.separator).omitEmptyStrings().trimResults();
    private Joiner joiner = Joiner.on((String)this.separator);

    public MybatisConfigurable() {
        this.mybatisSetting = MybatisSetting.getInstance();
    }

    public String getId() {
        return "Mybatis";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Free Mybatis";
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    public JComponent createComponent() {
        if (null == this.mybatisSettingForm) {
            this.mybatisSettingForm = new MybatisSettingForm();
        }
        return this.mybatisSettingForm.mainPanel;
    }

    public boolean isModified() {
        return this.mybatisSetting.getStatementGenerateModel().getIdentifier() != this.mybatisSettingForm.modelComboBox.getSelectedIndex() || !this.joiner.join(StatementGenerator.INSERT_GENERATOR.getPatterns()).equals(this.mybatisSettingForm.insertPatternTextField.getText()) || !this.joiner.join(StatementGenerator.DELETE_GENERATOR.getPatterns()).equals(this.mybatisSettingForm.deletePatternTextField.getText()) || !this.joiner.join(StatementGenerator.UPDATE_GENERATOR.getPatterns()).equals(this.mybatisSettingForm.updatePatternTextField.getText()) || !this.joiner.join(StatementGenerator.SELECT_GENERATOR.getPatterns()).equals(this.mybatisSettingForm.selectPatternTextField.getText());
    }

    public void apply() throws ConfigurationException {
        this.mybatisSetting.setStatementGenerateModel(GenerateModel.getInstance(this.mybatisSettingForm.modelComboBox.getSelectedIndex()));
        StatementGenerator.INSERT_GENERATOR.setPatterns(Sets.newHashSet((Iterable)this.splitter.split((CharSequence)this.mybatisSettingForm.insertPatternTextField.getText())));
        StatementGenerator.DELETE_GENERATOR.setPatterns(Sets.newHashSet((Iterable)this.splitter.split((CharSequence)this.mybatisSettingForm.deletePatternTextField.getText())));
        StatementGenerator.UPDATE_GENERATOR.setPatterns(Sets.newHashSet((Iterable)this.splitter.split((CharSequence)this.mybatisSettingForm.updatePatternTextField.getText())));
        StatementGenerator.SELECT_GENERATOR.setPatterns(Sets.newHashSet((Iterable)this.splitter.split((CharSequence)this.mybatisSettingForm.selectPatternTextField.getText())));
    }

    public void reset() {
        this.mybatisSettingForm.modelComboBox.setSelectedIndex(this.mybatisSetting.getStatementGenerateModel().getIdentifier());
        this.mybatisSettingForm.insertPatternTextField.setText(this.joiner.join(StatementGenerator.INSERT_GENERATOR.getPatterns()));
        this.mybatisSettingForm.deletePatternTextField.setText(this.joiner.join(StatementGenerator.DELETE_GENERATOR.getPatterns()));
        this.mybatisSettingForm.updatePatternTextField.setText(this.joiner.join(StatementGenerator.UPDATE_GENERATOR.getPatterns()));
        this.mybatisSettingForm.selectPatternTextField.setText(this.joiner.join(StatementGenerator.SELECT_GENERATOR.getPatterns()));
    }

    public void disposeUIResources() {
        this.mybatisSettingForm.mainPanel = null;
    }
}

