/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.service;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.wuzhizhan.mybatis.dom.model.IdDomElement;
import com.wuzhizhan.mybatis.dom.model.Mapper;
import com.wuzhizhan.mybatis.service.EditorService;
import com.wuzhizhan.mybatis.util.JavaUtils;
import com.wuzhizhan.mybatis.util.MapperUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaService {
    private Project project;
    private JavaPsiFacade javaPsiFacade;
    private EditorService editorService;

    public JavaService(Project project) {
        this.project = project;
        this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.editorService = EditorService.getInstance(project);
    }

    public static JavaService getInstance(@NotNull Project project) {
        if (project == null) {
            JavaService.$$$reportNull$$$0(0);
        }
        return (JavaService)ServiceManager.getService((Project)project, JavaService.class);
    }

    public Optional<PsiClass> getReferenceClazzOfPsiField(@NotNull PsiElement field) {
        if (field == null) {
            JavaService.$$$reportNull$$$0(1);
        }
        if (!(field instanceof PsiField)) {
            return Optional.empty();
        }
        PsiType type = ((PsiField)field).getType();
        return type instanceof PsiClassReferenceType ? Optional.ofNullable(((PsiClassReferenceType)type).resolve()) : Optional.empty();
    }

    public Optional<DomElement> findStatement(@Nullable PsiMethod method) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.process((PsiElement)method, (Processor)processor);
        return processor.isFound() ? Optional.ofNullable((DomElement)processor.getFoundValue()) : Optional.empty();
    }

    public void process(@NotNull PsiMethod psiMethod, @NotNull Processor<IdDomElement> processor) {
        PsiClass psiClass;
        if (psiMethod == null) {
            JavaService.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            JavaService.$$$reportNull$$$0(3);
        }
        if (null == (psiClass = psiMethod.getContainingClass())) {
            return;
        }
        String id = psiClass.getQualifiedName() + "." + psiMethod.getName();
        for (Mapper mapper : MapperUtils.findMappers(psiMethod.getProject())) {
            for (IdDomElement idDomElement : mapper.getDaoElements()) {
                if (!MapperUtils.getIdSignature(idDomElement).equals(id)) continue;
                processor.process((Object)idDomElement);
            }
        }
    }

    public void process(@NotNull PsiClass clazz, @NotNull Processor<Mapper> processor) {
        if (clazz == null) {
            JavaService.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JavaService.$$$reportNull$$$0(5);
        }
        String ns = clazz.getQualifiedName();
        for (Mapper mapper : MapperUtils.findMappers(clazz.getProject())) {
            if (!MapperUtils.getNamespace(mapper).equals(ns)) continue;
            processor.process((Object)mapper);
        }
    }

    public void process(@NotNull PsiElement target, @NotNull Processor processor) {
        if (target == null) {
            JavaService.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JavaService.$$$reportNull$$$0(7);
        }
        if (target instanceof PsiMethod) {
            this.process((PsiMethod)target, (Processor<IdDomElement>)processor);
        } else if (target instanceof PsiClass) {
            this.process((PsiClass)target, (Processor<Mapper>)processor);
        }
    }

    public <T> Optional<T> findWithFindFirstProcessor(@NotNull PsiElement target) {
        if (target == null) {
            JavaService.$$$reportNull$$$0(8);
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.process(target, (Processor)processor);
        return Optional.ofNullable(processor.getFoundValue());
    }

    public void importClazz(PsiJavaFile file, String clazzName) {
        if (!JavaUtils.hasImportClazz(file, clazzName)) {
            Optional<PsiClass> clazz = JavaUtils.findClazz(this.project, clazzName);
            PsiImportList importList = file.getImportList();
            if (clazz.isPresent() && null != importList) {
                PsiElementFactory elementFactory = this.javaPsiFacade.getElementFactory();
                PsiImportStatement statement = elementFactory.createImportStatement(clazz.get());
                importList.add((PsiElement)statement);
                this.editorService.format((PsiFile)file, (PsiElement)statement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/wuzhizhan/mybatis/service/JavaService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceClazzOfPsiField";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findWithFindFirstProcessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

