/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.service;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.wuzhizhan.mybatis.annotation.Annotation;
import com.wuzhizhan.mybatis.service.JavaService;
import com.wuzhizhan.mybatis.util.JavaUtils;
import org.jetbrains.annotations.NotNull;

public class AnnotationService {
    private Project project;

    public AnnotationService(Project project) {
        this.project = project;
    }

    public static AnnotationService getInstance(@NotNull Project project) {
        if (project == null) {
            AnnotationService.$$$reportNull$$$0(0);
        }
        return (AnnotationService)ServiceManager.getService((Project)project, AnnotationService.class);
    }

    public void addAnnotation(@NotNull PsiModifierListOwner parameter, @NotNull Annotation annotation) {
        if (parameter == null) {
            AnnotationService.$$$reportNull$$$0(1);
        }
        if (annotation == null) {
            AnnotationService.$$$reportNull$$$0(2);
        }
        PsiModifierList modifierList = parameter.getModifierList();
        if (JavaUtils.isAnnotationPresent(parameter, annotation) || null == modifierList) {
            return;
        }
        JavaService.getInstance(parameter.getProject()).importClazz((PsiJavaFile)parameter.getContainingFile(), annotation.getQualifiedName());
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.project).getElementFactory();
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText(annotation.toString(), (PsiElement)parameter);
        modifierList.add((PsiElement)psiAnnotation);
        JavaCodeStyleManager.getInstance((Project)this.project).shortenClassReferences(psiAnnotation.getParent());
    }

    public void addAnnotationWithParameterNameForMethodParameters(@NotNull PsiMethod method) {
        PsiParameter[] parameters;
        PsiParameterList parameterList;
        if (method == null) {
            AnnotationService.$$$reportNull$$$0(3);
        }
        if (null == (parameterList = method.getParameterList())) {
            return;
        }
        for (PsiParameter param : parameters = parameterList.getParameters()) {
            this.addAnnotationWithParameterName(param);
        }
    }

    public void addAnnotationWithParameterName(@NotNull PsiParameter parameter) {
        String name;
        if (parameter == null) {
            AnnotationService.$$$reportNull$$$0(4);
        }
        if (null != (name = parameter.getName())) {
            AnnotationService.getInstance(parameter.getProject()).addAnnotation((PsiModifierListOwner)parameter, Annotation.PARAM.withValue(new Annotation.StringValue(name)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/wuzhizhan/mybatis/service/AnnotationService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addAnnotationWithParameterNameForMethodParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addAnnotationWithParameterName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

