/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.reference;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.wuzhizhan.mybatis.util.MybatisConstants;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContextReferenceSetResolver<F extends PsiElement, K extends PsiElement> {
    private static final Splitter SPLITTER = Splitter.on((String)MybatisConstants.DOT_SEPARATOR);
    protected Project project;
    protected F element;
    protected List<String> texts;

    protected ContextReferenceSetResolver(@NotNull F element) {
        if (element == null) {
            ContextReferenceSetResolver.$$$reportNull$$$0(0);
        }
        this.element = element;
        this.project = element.getProject();
        this.texts = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)this.getText()));
    }

    @NotNull
    public final Optional<? extends PsiElement> resolve(int index) {
        Optional<K> startElement = this.getStartElement();
        Optional<Object> optional = startElement.isPresent() ? (this.texts.size() > 1 ? this.parseNext(startElement, this.texts, index) : startElement) : Optional.empty();
        if (optional == null) {
            ContextReferenceSetResolver.$$$reportNull$$$0(1);
        }
        return optional;
    }

    private Optional<K> parseNext(Optional<K> current, List<String> texts, int index) {
        for (int ind = 1; current.isPresent() && ind <= index; ++ind) {
            String text = texts.get(ind);
            if (text.contains(" ")) {
                return Optional.empty();
            }
            current = this.resolve((PsiElement)current.get(), text);
        }
        return current;
    }

    public Optional<K> getStartElement() {
        return this.getStartElement((String)Iterables.getFirst(this.texts, null));
    }

    @NotNull
    public abstract Optional<K> getStartElement(@Nullable String var1);

    @NotNull
    public abstract String getText();

    @NotNull
    public abstract Optional<K> resolve(@NotNull K var1, @NotNull String var2);

    public F getElement() {
        return this.element;
    }

    public void setElement(F element) {
        this.element = element;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/reference/ContextReferenceSetResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/reference/ContextReferenceSetResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

