/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.reference;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.wuzhizhan.mybatis.dom.MapperBacktrackingUtils;
import com.wuzhizhan.mybatis.reference.ContextReferenceSetResolver;
import com.wuzhizhan.mybatis.reference.ReferenceSetResolverFactory;
import com.wuzhizhan.mybatis.service.JavaService;
import com.wuzhizhan.mybatis.util.JavaUtils;
import com.wuzhizhan.mybatis.util.MybatisConstants;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextPsiFieldReference
extends PsiReferenceBase<XmlAttributeValue> {
    protected ContextReferenceSetResolver resolver;
    protected int index;

    public ContextPsiFieldReference(XmlAttributeValue element, TextRange range, int index) {
        super((PsiElement)element, range, false);
        this.index = index;
        this.resolver = ReferenceSetResolverFactory.createPsiFieldResolver(element);
    }

    @Nullable
    public PsiElement resolve() {
        Optional<PsiElement> resolved = this.resolver.resolve(this.index);
        return resolved.orElse(null);
    }

    @NotNull
    public Object[] getVariants() {
        Optional<PsiClass> clazz = this.getTargetClazz();
        Object[] objectArray = clazz.isPresent() ? JavaUtils.findSettablePsiFields(clazz.get()) : PsiReference.EMPTY_ARRAY;
        if (objectArray == null) {
            ContextPsiFieldReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private Optional<PsiClass> getTargetClazz() {
        if (((XmlAttributeValue)this.getElement()).getValue().contains(MybatisConstants.DOT_SEPARATOR)) {
            int ind = 0 == this.index ? 0 : this.index - 1;
            Optional<PsiElement> resolved = this.resolver.resolve(ind);
            if (resolved.isPresent()) {
                return JavaService.getInstance(((XmlAttributeValue)this.myElement).getProject()).getReferenceClazzOfPsiField(resolved.get());
            }
        } else {
            return MapperBacktrackingUtils.getPropertyClazz((XmlAttributeValue)this.myElement);
        }
        return Optional.empty();
    }

    public ContextReferenceSetResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ContextReferenceSetResolver resolver) {
        this.resolver = resolver;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/wuzhizhan/mybatis/reference/ContextPsiFieldReference", "getVariants"));
    }
}

