/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.provider;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.wuzhizhan.mybatis.annotation.Annotation;
import com.wuzhizhan.mybatis.dom.model.Mapper;
import com.wuzhizhan.mybatis.util.Icons;
import com.wuzhizhan.mybatis.util.JavaUtils;
import com.wuzhizhan.mybatis.util.MapperUtils;
import java.util.Collection;
import java.util.Optional;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InjectionLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            InjectionLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            InjectionLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)element;
        if (!this.isTargetField(field)) {
            return;
        }
        PsiType type = field.getType();
        if (!(type instanceof PsiClassReferenceType)) {
            return;
        }
        Optional<PsiClass> clazz = JavaUtils.findClazz(element.getProject(), type.getCanonicalText());
        if (!clazz.isPresent()) {
            return;
        }
        PsiClass psiClass = clazz.get();
        Optional<Mapper> mapper = MapperUtils.findFirstMapper(element.getProject(), psiClass);
        if (!mapper.isPresent()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)Icons.SPRING_INJECTION_ICON).setAlignment(GutterIconRenderer.Alignment.CENTER).setTarget((Object)psiClass).setTooltipTitle("Data access object found - " + psiClass.getQualifiedName());
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)field.getNameIdentifier()));
    }

    private boolean isTargetField(PsiField field) {
        if (JavaUtils.isAnnotationPresent((PsiModifierListOwner)field, Annotation.AUTOWIRED)) {
            return true;
        }
        Optional<PsiAnnotation> resourceAnno = JavaUtils.getPsiAnnotation((PsiModifierListOwner)field, Annotation.RESOURCE);
        if (resourceAnno.isPresent()) {
            PsiAnnotationMemberValue nameValue = resourceAnno.get().findAttributeValue("name");
            String name = nameValue.getText().replaceAll("\"", "");
            return StringUtils.isBlank((String)name) || name.equals(field.getName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/wuzhizhan/mybatis/provider/InjectionLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

