/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.intention;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.wuzhizhan.mybatis.intention.GenerateMapperChooser;
import com.wuzhizhan.mybatis.intention.GenericIntention;
import com.wuzhizhan.mybatis.service.EditorService;
import com.wuzhizhan.mybatis.ui.ClickableListener;
import com.wuzhizhan.mybatis.ui.ListSelectionListener;
import com.wuzhizhan.mybatis.ui.UiComponentFacade;
import com.wuzhizhan.mybatis.util.CollectionUtils;
import com.wuzhizhan.mybatis.util.MapperUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class GenerateMapperIntention
extends GenericIntention {
    public GenerateMapperIntention() {
        super(GenerateMapperChooser.INSTANCE);
    }

    @NotNull
    public String getText() {
        return "[Mybatis] MybatisGenerator mapper of xml";
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            GenerateMapperIntention.$$$reportNull$$$0(0);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        Collection<PsiDirectory> directories = MapperUtils.findMapperDirectories(project);
        if (CollectionUtils.isEmpty(directories)) {
            this.handleChooseNewFolder(project, editor, clazz);
        } else {
            this.handleMutilDirectories(project, editor, clazz, directories);
        }
    }

    private void handleMutilDirectories(Project project, final Editor editor, final PsiClass clazz, Collection<PsiDirectory> directories) {
        final Map<String, PsiDirectory> pathMap = this.getPathMap(directories);
        final ArrayList keys = Lists.newArrayList(pathMap.keySet());
        ListSelectionListener popupListener = new ListSelectionListener(){

            @Override
            public void selected(int index) {
                GenerateMapperIntention.this.processGenerate(editor, clazz, (PsiDirectory)pathMap.get(keys.get(index)));
            }

            @Override
            public boolean isWriteAction() {
                return true;
            }
        };
        UiComponentFacade uiComponentFacade = UiComponentFacade.getInstance(project);
        uiComponentFacade.showListPopupWithSingleClickable("Choose folder", popupListener, "Choose another", this.getChooseFolderListener(editor, clazz), this.getPathTextForShown(project, keys, pathMap));
    }

    private ClickableListener getChooseFolderListener(final Editor editor, final PsiClass clazz) {
        final Project project = clazz.getProject();
        return new ClickableListener(){

            @Override
            public void clicked() {
                GenerateMapperIntention.this.handleChooseNewFolder(project, editor, clazz);
            }

            @Override
            public boolean isWriteAction() {
                return false;
            }
        };
    }

    private void handleChooseNewFolder(Project project, Editor editor, PsiClass clazz) {
        UiComponentFacade uiComponentFacade = UiComponentFacade.getInstance(project);
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile vf = uiComponentFacade.showSingleFolderSelectionDialog("Select target folder", baseDir, baseDir);
        if (null != vf) {
            this.processGenerate(editor, clazz, PsiManager.getInstance((Project)project).findDirectory(vf));
        }
    }

    private String[] getPathTextForShown(Project project, List<String> paths, final Map<String, PsiDirectory> pathMap) {
        Collections.sort(paths);
        final String projectBasePath = project.getBasePath();
        ArrayList result = Lists.newArrayList((Iterable)Collections2.transform(paths, (Function)new Function<String, String>(){

            public String apply(String input) {
                String relativePath = FileUtil.getRelativePath((String)projectBasePath, (String)input, (char)File.separatorChar);
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)pathMap.get(input)));
                return null == module ? relativePath : "[" + module.getName() + "] " + relativePath;
            }
        }));
        return result.toArray(new String[result.size()]);
    }

    private Map<String, PsiDirectory> getPathMap(Collection<PsiDirectory> directories) {
        HashMap result = Maps.newHashMap();
        for (PsiDirectory directory : directories) {
            String presentableUrl = directory.getVirtualFile().getPresentableUrl();
            if (presentableUrl == null) continue;
            result.put(presentableUrl, directory);
        }
        return result;
    }

    private void processGenerate(Editor editor, PsiClass clazz, PsiDirectory directory) {
        if (null == directory) {
            return;
        }
        if (!directory.isWritable()) {
            HintManager.getInstance().showErrorHint(editor, "Target directory is not writable");
            return;
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("NAMESPACE", clazz.getQualifiedName());
            PsiElement psiFile = MapperUtils.createMapperFromFileTemplate("Mybatis Mapper.xml", clazz.getName(), directory, properties);
            EditorService.getInstance(clazz.getProject()).scrollTo(psiFile, 0);
        }
        catch (Exception e) {
            HintManager.getInstance().showErrorHint(editor, "Failed: " + e.getCause());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/wuzhizhan/mybatis/intention/GenerateMapperIntention", "invoke"));
    }
}

