/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.xml.DomElement;
import com.wuzhizhan.mybatis.annotation.Annotation;
import com.wuzhizhan.mybatis.dom.model.Select;
import com.wuzhizhan.mybatis.generate.StatementGenerator;
import com.wuzhizhan.mybatis.inspection.MapperInspection;
import com.wuzhizhan.mybatis.inspection.ResultTypeQuickFix;
import com.wuzhizhan.mybatis.inspection.StatementNotExistsQuickFix;
import com.wuzhizhan.mybatis.locator.MapperLocator;
import com.wuzhizhan.mybatis.service.JavaService;
import com.wuzhizhan.mybatis.util.JavaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapperMethodInspection
extends MapperInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            MapperMethodInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MapperMethodInspection.$$$reportNull$$$0(1);
        }
        if (!MapperLocator.getInstance(method.getProject()).process(method) || JavaUtils.isAnyAnnotationPresent((PsiModifierListOwner)method, Annotation.STATEMENT_SYMMETRIES) || method.getModifierList().hasModifierProperty("static")) {
            return EMPTY_ARRAY;
        }
        List<ProblemDescriptor> problems = this.createProblemDescriptors(method, manager, isOnTheFly);
        return problems.toArray(new ProblemDescriptor[0]);
    }

    private List<ProblemDescriptor> createProblemDescriptors(PsiMethod method, InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        Optional<ProblemDescriptor> optionalProblem = this.checkStatementExists(method, manager, isOnTheFly);
        if (optionalProblem.isPresent()) {
            problems.add(optionalProblem.get());
        }
        if ((optionalProblem = this.checkResultType(method, manager, isOnTheFly)).isPresent()) {
            problems.add(optionalProblem.get());
        }
        return problems;
    }

    private Optional<ProblemDescriptor> checkResultType(PsiMethod method, InspectionManager manager, boolean isOnTheFly) {
        Optional<DomElement> optionalDomElement = JavaService.getInstance(method.getProject()).findStatement(method);
        if (!optionalDomElement.isPresent()) {
            return Optional.empty();
        }
        DomElement domElement = optionalDomElement.get();
        if (domElement instanceof Select) {
            Select selectStatement = (Select)domElement;
            if (selectStatement.getResultMap().getValue() != null) {
                return Optional.empty();
            }
            Optional<PsiClass> methodResultType = StatementGenerator.getSelectResultType(method);
            PsiClass selectResultType = (PsiClass)selectStatement.getResultType().getValue();
            PsiIdentifier methodName = method.getNameIdentifier();
            if (methodName != null) {
                if (methodResultType.isPresent() && (selectResultType == null || selectResultType.getQualifiedName() != null && !selectResultType.getQualifiedName().equals(methodResultType.get().getQualifiedName()) && !selectResultType.isInheritor(methodResultType.get(), true))) {
                    return Optional.of(manager.createProblemDescriptor((PsiElement)methodName, "Result type doesn't match for Select id=\"#ref\"", (LocalQuickFix)new ResultTypeQuickFix(selectStatement, methodResultType.get()), ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
                }
                if (!methodResultType.isPresent() && selectResultType != null) {
                    return Optional.of(manager.createProblemDescriptor((PsiElement)methodName, "Result type doesn't match for Select id=\"#ref\"", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
                }
            }
        }
        return Optional.empty();
    }

    private Optional<ProblemDescriptor> checkStatementExists(PsiMethod method, InspectionManager manager, boolean isOnTheFly) {
        PsiIdentifier methodName = method.getNameIdentifier();
        if (method.hasModifierProperty("default")) {
            return Optional.empty();
        }
        if (!JavaService.getInstance(method.getProject()).findStatement(method).isPresent() && null != methodName) {
            return Optional.of(manager.createProblemDescriptor((PsiElement)methodName, "Statement with id=\"#ref\" not defined in mapper XML", (LocalQuickFix)new StatementNotExistsQuickFix(method), ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
        }
        return Optional.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/wuzhizhan/mybatis/inspection/MapperMethodInspection";
        objectArray[2] = "checkMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

