/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.generate;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.wuzhizhan.mybatis.dom.model.GroupTwo;
import com.wuzhizhan.mybatis.dom.model.Mapper;
import com.wuzhizhan.mybatis.generate.DeleteGenerator;
import com.wuzhizhan.mybatis.generate.GenerateModel;
import com.wuzhizhan.mybatis.generate.InsertGenerator;
import com.wuzhizhan.mybatis.generate.SelectGenerator;
import com.wuzhizhan.mybatis.generate.UpdateGenerator;
import com.wuzhizhan.mybatis.service.EditorService;
import com.wuzhizhan.mybatis.service.JavaService;
import com.wuzhizhan.mybatis.setting.MybatisSetting;
import com.wuzhizhan.mybatis.ui.ListSelectionListener;
import com.wuzhizhan.mybatis.ui.UiComponentFacade;
import com.wuzhizhan.mybatis.util.CollectionUtils;
import com.wuzhizhan.mybatis.util.JavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatementGenerator {
    public static final StatementGenerator UPDATE_GENERATOR = new UpdateGenerator("update", "modify", "set");
    public static final StatementGenerator SELECT_GENERATOR = new SelectGenerator("select", "get", "look", "find", "list", "search", "count", "query");
    public static final StatementGenerator DELETE_GENERATOR = new DeleteGenerator("del", "cancel");
    public static final StatementGenerator INSERT_GENERATOR = new InsertGenerator("insert", "add", "new");
    public static final Set<StatementGenerator> ALL = ImmutableSet.of((Object)UPDATE_GENERATOR, (Object)SELECT_GENERATOR, (Object)DELETE_GENERATOR, (Object)INSERT_GENERATOR);
    private static final Function<Mapper, String> FUN = new Function<Mapper, String>(){

        public String apply(Mapper mapper) {
            VirtualFile vf = mapper.getXmlTag().getContainingFile().getVirtualFile();
            if (null == vf) {
                return "";
            }
            return vf.getCanonicalPath();
        }
    };
    private Set<String> patterns;

    public static Optional<PsiClass> getSelectResultType(@Nullable PsiMethod method) {
        if (null == method) {
            return Optional.empty();
        }
        PsiType returnType = method.getReturnType();
        if (returnType instanceof PsiPrimitiveType && returnType != PsiType.VOID) {
            return JavaUtils.findClazz(method.getProject(), ((PsiPrimitiveType)returnType).getBoxedTypeName());
        }
        if (returnType instanceof PsiClassReferenceType) {
            PsiType[] parameters;
            PsiClassReferenceType type = (PsiClassReferenceType)returnType;
            if (type.hasParameters() && (parameters = type.getParameters()).length == 1) {
                type = (PsiClassReferenceType)parameters[0];
            }
            return Optional.ofNullable(type.resolve());
        }
        return Optional.empty();
    }

    private static void doGenerate(final @NotNull StatementGenerator generator, final @NotNull PsiMethod method) {
        if (generator == null) {
            StatementGenerator.$$$reportNull$$$0(0);
        }
        if (method == null) {
            StatementGenerator.$$$reportNull$$$0(1);
        }
        new WriteCommandAction.Simple(method.getProject(), new PsiFile[]{method.getContainingFile()}){

            protected void run() throws Throwable {
                generator.execute(method);
            }
        }.execute();
    }

    public static void applyGenerate(final @Nullable PsiMethod method) {
        if (null == method) {
            return;
        }
        final Project project = method.getProject();
        Object[] generators = StatementGenerator.getGenerators(method);
        if (1 == generators.length) {
            generators[0].execute(method);
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep("[ Statement type for method: " + method.getName() + "]", generators){

                public PopupStep onChosen(final Object selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    StatementGenerator.doGenerate((StatementGenerator)selectedValue, method);
                                }
                            });
                        }
                    });
                }
            }).showInFocusCenter();
        }
    }

    @NotNull
    public static StatementGenerator[] getGenerators(@NotNull PsiMethod method) {
        if (method == null) {
            StatementGenerator.$$$reportNull$$$0(2);
        }
        GenerateModel model = MybatisSetting.getInstance().getStatementGenerateModel();
        String target = method.getName();
        ArrayList result = Lists.newArrayList();
        for (StatementGenerator generator : ALL) {
            if (!model.matchesAny(generator.getPatterns(), target)) continue;
            result.add(generator);
        }
        StatementGenerator[] statementGeneratorArray = CollectionUtils.isNotEmpty(result) ? result.toArray(new StatementGenerator[result.size()]) : ALL.toArray(new StatementGenerator[ALL.size()]);
        if (statementGeneratorArray == null) {
            StatementGenerator.$$$reportNull$$$0(3);
        }
        return statementGeneratorArray;
    }

    public StatementGenerator(String ... patterns) {
        if (patterns == null) {
            StatementGenerator.$$$reportNull$$$0(4);
        }
        this.patterns = Sets.newHashSet((Object[])patterns);
    }

    public void execute(final @NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            StatementGenerator.$$$reportNull$$$0(5);
        }
        if (null == (psiClass = method.getContainingClass())) {
            return;
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JavaService.getInstance(method.getProject()).process(psiClass, (Processor<Mapper>)processor);
        final ArrayList mappers = Lists.newArrayList((Iterable)processor.getResults());
        if (1 == mappers.size()) {
            this.setupTag(method, (Mapper)Iterables.getOnlyElement((Iterable)mappers, null));
        } else if (mappers.size() > 1) {
            Collection paths = Collections2.transform((Collection)mappers, FUN);
            UiComponentFacade.getInstance(method.getProject()).showListPopup("Choose target mapper xml to generate", new ListSelectionListener(){

                @Override
                public void selected(int index) {
                    StatementGenerator.this.setupTag(method, (Mapper)mappers.get(index));
                }

                @Override
                public boolean isWriteAction() {
                    return true;
                }
            }, paths.toArray(new String[paths.size()]));
        }
    }

    private void setupTag(PsiMethod method, Mapper mapper) {
        GroupTwo target = this.getTarget(mapper, method);
        target.getId().setStringValue(method.getName());
        target.setValue(" ");
        XmlTag tag = target.getXmlTag();
        int offset = tag.getTextOffset() + tag.getTextLength() - tag.getName().length() + 1;
        EditorService editorService = EditorService.getInstance(method.getProject());
        editorService.format(tag.getContainingFile(), (PsiElement)tag);
        editorService.scrollTo((PsiElement)tag, offset);
    }

    public String toString() {
        return this.getDisplayText();
    }

    @NotNull
    protected abstract GroupTwo getTarget(@NotNull Mapper var1, @NotNull PsiMethod var2);

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayText();

    public Set<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Set<String> patterns) {
        this.patterns = patterns;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/generate/StatementGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/generate/StatementGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGenerate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGenerators";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

