/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.dom.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.wuzhizhan.mybatis.dom.converter.ConverterAdaptor;
import com.wuzhizhan.mybatis.dom.model.IdDomElement;
import com.wuzhizhan.mybatis.dom.model.Mapper;
import com.wuzhizhan.mybatis.util.MapperUtils;
import com.wuzhizhan.mybatis.util.MybatisConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdBasedTagConverter
extends ConverterAdaptor<XmlAttributeValue>
implements CustomReferenceConverter<XmlAttributeValue> {
    private final boolean crossMapperSupported;

    public IdBasedTagConverter() {
        this(true);
    }

    protected IdBasedTagConverter(boolean crossMapperSupported) {
        this.crossMapperSupported = crossMapperSupported;
    }

    @Override
    @Nullable
    public XmlAttributeValue fromString(@Nullable @NonNls String value, ConvertContext context) {
        return this.matchIdDomElement(this.selectStrategy(context).getValue(), value, context).orElse(null);
    }

    @NotNull
    private Optional<XmlAttributeValue> matchIdDomElement(Collection<? extends IdDomElement> idDomElements, String value, ConvertContext context) {
        Mapper contextMapper = MapperUtils.getMapper(context.getInvocationElement());
        for (IdDomElement idDomElement : idDomElements) {
            if (!MapperUtils.getIdSignature(idDomElement).equals(value) && !MapperUtils.getIdSignature(idDomElement, contextMapper).equals(value)) continue;
            Optional<XmlAttributeValue> optional = Optional.of(idDomElement.getId().getXmlAttributeValue());
            if (optional == null) {
                IdBasedTagConverter.$$$reportNull$$$0(0);
            }
            return optional;
        }
        Optional<XmlAttributeValue> optional = Optional.empty();
        if (optional == null) {
            IdBasedTagConverter.$$$reportNull$$$0(1);
        }
        return optional;
    }

    @Override
    @Nullable
    public String toString(@Nullable XmlAttributeValue xmlAttribute, ConvertContext context) {
        DomElement domElement = DomUtil.getDomElement((PsiElement)xmlAttribute.getParent().getParent());
        if (!(domElement instanceof IdDomElement)) {
            return null;
        }
        Mapper contextMapper = MapperUtils.getMapper(context.getInvocationElement());
        return MapperUtils.getIdSignature((IdDomElement)domElement, contextMapper);
    }

    private TraverseStrategy selectStrategy(ConvertContext context) {
        return this.crossMapperSupported ? new CrossMapperStrategy(context) : new InsideMapperStrategy(context);
    }

    @NotNull
    public abstract Collection<? extends IdDomElement> getComparisons(@Nullable Mapper var1, ConvertContext var2);

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<XmlAttributeValue> value, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = PsiClassConverter.createJavaClassReferenceProvider(value, null, (JavaClassReferenceProvider)new ValueReferenceProvider(context)).getReferencesByElement(element);
        if (psiReferenceArray == null) {
            IdBasedTagConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "matchIdDomElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private abstract class TraverseStrategy {
        protected ConvertContext context;

        public TraverseStrategy(ConvertContext context) {
            if (context == null) {
                TraverseStrategy.$$$reportNull$$$0(0);
            }
            this.context = context;
        }

        public abstract Collection<? extends IdDomElement> getValue();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$TraverseStrategy", "<init>"));
        }
    }

    private class CrossMapperStrategy
    extends TraverseStrategy {
        public CrossMapperStrategy(ConvertContext context) {
            if (context == null) {
                CrossMapperStrategy.$$$reportNull$$$0(0);
            }
            super(context);
        }

        @Override
        public Collection<? extends IdDomElement> getValue() {
            ArrayList result = Lists.newArrayList();
            for (Mapper mapper : MapperUtils.findMappers(this.context.getProject())) {
                result.addAll(IdBasedTagConverter.this.getComparisons(mapper, this.context));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$CrossMapperStrategy", "<init>"));
        }
    }

    private class InsideMapperStrategy
    extends TraverseStrategy {
        public InsideMapperStrategy(ConvertContext context) {
            if (context == null) {
                InsideMapperStrategy.$$$reportNull$$$0(0);
            }
            super(context);
        }

        @Override
        public Collection<? extends IdDomElement> getValue() {
            return IdBasedTagConverter.this.getComparisons(null, this.context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$InsideMapperStrategy", "<init>"));
        }
    }

    private class ValueReferenceProvider
    extends JavaClassReferenceProvider {
        private ConvertContext context;

        private ValueReferenceProvider(ConvertContext context) {
            this.context = context;
        }

        @Nullable
        public GlobalSearchScope getScope(Project project) {
            return GlobalSearchScope.allScope((Project)project);
        }

        @NotNull
        public PsiReference[] getReferencesByString(String text, @NotNull PsiElement position, int offsetInPosition) {
            if (position == null) {
                ValueReferenceProvider.$$$reportNull$$$0(0);
            }
            ArrayList refs = Lists.newArrayList((Object[])super.getReferencesByString(text, position, offsetInPosition));
            ValueReference vr = new ValueReference(position, this.getTextRange(position), this.context, text);
            if (!refs.isEmpty() && 0 != vr.getVariants().length) {
                refs.remove(refs.size() - 1);
                refs.add(vr);
            }
            PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
            if (psiReferenceArray == null) {
                ValueReferenceProvider.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }

        private TextRange getTextRange(PsiElement element) {
            String text = element.getText();
            int index = text.lastIndexOf(MybatisConstants.DOT_SEPARATOR);
            return -1 == index ? ElementManipulators.getValueTextRange((PsiElement)element) : TextRange.create((int)(text.substring(0, index).length() + 1), (int)(text.length() - 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$ValueReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$ValueReferenceProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByString";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ValueReference
    extends PsiReferenceBase<PsiElement> {
        private ConvertContext context;
        private String text;

        public ValueReference(PsiElement element, TextRange rng, ConvertContext context, String text) {
            if (element == null) {
                ValueReference.$$$reportNull$$$0(0);
            }
            super(element, rng, false);
            this.context = context;
            this.text = text;
        }

        @Nullable
        public PsiElement resolve() {
            return IdBasedTagConverter.this.fromString(this.text, this.context);
        }

        @NotNull
        public Object[] getVariants() {
            Set<String> res = this.getElement().getText().contains(MybatisConstants.DOT_SEPARATOR) ? this.setupContextIdSignature() : this.setupGlobalIdSignature();
            Object[] objectArray = res.toArray(new String[res.size()]);
            if (objectArray == null) {
                ValueReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private Set<String> setupContextIdSignature() {
            HashSet res = Sets.newHashSet();
            String ns = this.text.substring(0, this.text.lastIndexOf(MybatisConstants.DOT_SEPARATOR));
            for (IdDomElement idDomElement : IdBasedTagConverter.this.selectStrategy(this.context).getValue()) {
                if (!MapperUtils.getNamespace(idDomElement).equals(ns)) continue;
                res.add(MapperUtils.getId(idDomElement));
            }
            return res;
        }

        private Set<String> setupGlobalIdSignature() {
            Mapper contextMapper = MapperUtils.getMapper(this.context.getInvocationElement());
            Collection<? extends IdDomElement> idDomElements = IdBasedTagConverter.this.selectStrategy(this.context).getValue();
            HashSet<String> res = new HashSet<String>(idDomElements.size());
            for (IdDomElement idDomElement : idDomElements) {
                res.add(MapperUtils.getIdSignature(idDomElement, contextMapper));
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$ValueReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/wuzhizhan/mybatis/dom/converter/IdBasedTagConverter$ValueReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

