/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.contributor;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.wuzhizhan.mybatis.contributor.TestParamContributor;
import com.wuzhizhan.mybatis.dom.model.IdDomElement;
import com.wuzhizhan.mybatis.util.DomUtils;
import com.wuzhizhan.mybatis.util.MapperUtils;
import java.util.Optional;

public class SqlParamCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiFile topLevelFile = InjectedLanguageUtil.getTopLevelFile((PsiElement)position);
        if (DomUtils.isMybatisFile(topLevelFile) && this.shouldAddElement(position.getContainingFile(), parameters.getOffset())) {
            this.process(topLevelFile, result, position);
        }
    }

    private void process(PsiFile xmlFile, CompletionResultSet result, PsiElement position) {
        int offset;
        Optional<IdDomElement> idDomElement;
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)position);
        if (null != documentWindow && (idDomElement = MapperUtils.findParentIdDomElement(xmlFile.findElementAt(offset = documentWindow.injectedToHost(position.getTextOffset())))).isPresent()) {
            TestParamContributor.addElementForPsiParameter(position.getProject(), result, idDomElement.get());
            result.stopHere();
        }
    }

    private boolean shouldAddElement(PsiFile file, int offset) {
        String text = file.getText();
        for (int i = offset - 1; i > 0; --i) {
            char c = text.charAt(i);
            if (c != '{' || text.charAt(i - 1) != '#') continue;
            return true;
        }
        return false;
    }
}

