/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.annotation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Annotation
implements Cloneable {
    public static final Annotation PARAM = new Annotation("@Param", "org.apache.ibatis.annotations.Param");
    public static final Annotation SELECT = new Annotation("@Select", "org.apache.ibatis.annotations.Select");
    public static final Annotation UPDATE = new Annotation("@Update", "org.apache.ibatis.annotations.Update");
    public static final Annotation INSERT = new Annotation("@Insert", "org.apache.ibatis.annotations.Insert");
    public static final Annotation DELETE = new Annotation("@Delete", "org.apache.ibatis.annotations.Delete");
    public static final Annotation ALIAS = new Annotation("@Alias", "org.apache.ibatis.type.Alias");
    public static final Annotation AUTOWIRED = new Annotation("@Autowired", "org.springframework.beans.factory.annotation.Autowired");
    public static final Annotation RESOURCE = new Annotation("@Resource", "javax.annotation.Resource");
    public static final Annotation SelectProvider = new Annotation("@SelectProvider", "org.apache.ibatis.annotations.SelectProvider");
    public static final Annotation InsertProvider = new Annotation("@InsertProvider", "org.apache.ibatis.annotations.InsertProvider");
    public static final Annotation DeleteProvider = new Annotation("@DeleteProvider", "org.apache.ibatis.annotations.DeleteProvider");
    public static final Annotation UpdateProvider = new Annotation("@UpdateProvider", "org.apache.ibatis.annotations.UpdateProvider");
    public static final Set<Annotation> STATEMENT_SYMMETRIES = ImmutableSet.of((Object)SELECT, (Object)UPDATE, (Object)INSERT, (Object)DELETE, (Object)SelectProvider, (Object)InsertProvider, (Object[])new Annotation[]{DeleteProvider, UpdateProvider});
    private final String label;
    private final String qualifiedName;
    private Map<String, AnnotationValue> attributePairs;

    public Annotation(@NotNull String label, @NotNull String qualifiedName) {
        if (label == null) {
            Annotation.$$$reportNull$$$0(0);
        }
        if (qualifiedName == null) {
            Annotation.$$$reportNull$$$0(1);
        }
        this.label = label;
        this.qualifiedName = qualifiedName;
        this.attributePairs = Maps.newHashMap();
    }

    private Annotation addAttribute(String key, AnnotationValue value) {
        this.attributePairs.put(key, value);
        return this;
    }

    public Annotation withAttribute(@NotNull String key, @NotNull AnnotationValue value) {
        if (key == null) {
            Annotation.$$$reportNull$$$0(2);
        }
        if (value == null) {
            Annotation.$$$reportNull$$$0(3);
        }
        Annotation copy = this.clone();
        copy.attributePairs = Maps.newHashMap(this.attributePairs);
        return copy.addAttribute(key, value);
    }

    public Annotation withValue(@NotNull AnnotationValue value) {
        if (value == null) {
            Annotation.$$$reportNull$$$0(4);
        }
        return this.withAttribute("value", value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.label);
        if (!Iterables.isEmpty(this.attributePairs.entrySet())) {
            builder.append(this.setupAttributeText());
        }
        return builder.toString();
    }

    private String setupAttributeText() {
        Optional<String> singleValue = this.getSingleValue();
        return singleValue.isPresent() ? singleValue.get() : this.getComplexValue();
    }

    private String getComplexValue() {
        StringBuilder builder = new StringBuilder("(");
        for (String key : this.attributePairs.keySet()) {
            builder.append(key);
            builder.append(" = ");
            builder.append(this.attributePairs.get(key).toString());
            builder.append(", ");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }

    @NotNull
    public Optional<PsiClass> toPsiClass(@NotNull Project project) {
        if (project == null) {
            Annotation.$$$reportNull$$$0(5);
        }
        Optional<PsiClass> optional = Optional.ofNullable(JavaPsiFacade.getInstance((Project)project).findClass(this.getQualifiedName(), GlobalSearchScope.allScope((Project)project)));
        if (optional == null) {
            Annotation.$$$reportNull$$$0(6);
        }
        return optional;
    }

    private Optional<String> getSingleValue() {
        try {
            String value = (String)Iterables.getOnlyElement(this.attributePairs.keySet());
            StringBuilder builder = new StringBuilder("(");
            builder.append(this.attributePairs.get(value).toString());
            builder.append(")");
            return Optional.of(builder.toString());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @NotNull
    public String getLabel() {
        String string = this.label;
        if (string == null) {
            Annotation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.qualifiedName;
        if (string == null) {
            Annotation.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected Annotation clone() {
        try {
            return (Annotation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/annotation/Annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/annotation/Annotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toPsiClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AnnotationValue {
    }

    public static class StringValue
    implements AnnotationValue {
        private String value;

        public StringValue(@NotNull String value) {
            if (value == null) {
                StringValue.$$$reportNull$$$0(0);
            }
            this.value = value;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/wuzhizhan/mybatis/annotation/Annotation$StringValue", "<init>"));
        }
    }
}

