/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.alias;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.wuzhizhan.mybatis.alias.AliasDesc;
import com.wuzhizhan.mybatis.alias.AliasResolver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageAliasResolver
extends AliasResolver {
    private JavaPsiFacade javaPsiFacade;

    public PackageAliasResolver(Project project) {
        super(project);
        this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
    }

    @Override
    @NotNull
    public Set<AliasDesc> getClassAliasDescriptions(@Nullable PsiElement element) {
        HashSet result = Sets.newHashSet();
        for (String pkgName : this.getPackages(element)) {
            PsiPackage pkg;
            if (null == pkgName || null == (pkg = this.javaPsiFacade.findPackage(pkgName))) continue;
            this.addAliasDesc(result, pkg);
            for (PsiPackage tmp : pkg.getSubPackages()) {
                this.addAliasDesc(result, tmp);
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            PackageAliasResolver.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private void addAliasDesc(Set<AliasDesc> result, PsiPackage pkg) {
        for (PsiClass clazz : pkg.getClasses()) {
            this.addAliasDesc(result, clazz, clazz.getName());
        }
    }

    @NotNull
    public abstract Collection<String> getPackages(@Nullable PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/wuzhizhan/mybatis/alias/PackageAliasResolver", "getClassAliasDescriptions"));
    }
}

