/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.alias;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.wuzhizhan.mybatis.alias.AliasDesc;
import com.wuzhizhan.mybatis.alias.AliasResolver;
import com.wuzhizhan.mybatis.annotation.Annotation;
import com.wuzhizhan.mybatis.util.JavaUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationAliasResolver
extends AliasResolver {
    private static final Function FUN = new Function<PsiClass, AliasDesc>(){

        public AliasDesc apply(PsiClass psiClass) {
            Optional<String> txt = JavaUtils.getAnnotationValueText((PsiModifierListOwner)psiClass, Annotation.ALIAS);
            if (!txt.isPresent()) {
                return null;
            }
            AliasDesc ad = new AliasDesc();
            ad.setAlias(txt.get());
            ad.setClazz(psiClass);
            return ad;
        }
    };

    public AnnotationAliasResolver(Project project) {
        super(project);
    }

    public static final AnnotationAliasResolver getInstance(@NotNull Project project) {
        if (project == null) {
            AnnotationAliasResolver.$$$reportNull$$$0(0);
        }
        return (AnnotationAliasResolver)project.getComponent(AnnotationAliasResolver.class);
    }

    @Override
    @NotNull
    public Set<AliasDesc> getClassAliasDescriptions(@Nullable PsiElement element) {
        Optional<PsiClass> clazz = Annotation.ALIAS.toPsiClass(this.project);
        if (clazz.isPresent()) {
            Collection res = AnnotatedElementsSearch.searchPsiClasses((PsiClass)clazz.get(), (SearchScope)GlobalSearchScope.allScope((Project)this.project)).findAll();
            HashSet hashSet = Sets.newHashSet((Iterable)Collections2.transform((Collection)res, (Function)FUN));
            if (hashSet == null) {
                AnnotationAliasResolver.$$$reportNull$$$0(1);
            }
            return hashSet;
        }
        Set<AliasDesc> set = Collections.emptySet();
        if (set == null) {
            AnnotationAliasResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/alias/AnnotationAliasResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/alias/AnnotationAliasResolver";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAliasDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

