/*
 * Decompiled with CFR 0.152.
 */
package com.wuzhizhan.mybatis.alias;

import com.google.common.collect.Lists;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.wuzhizhan.mybatis.alias.AliasDesc;
import com.wuzhizhan.mybatis.alias.AliasResolver;
import com.wuzhizhan.mybatis.alias.AliasResolverFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AliasFacade {
    private Project project;
    private JavaPsiFacade javaPsiFacade;
    private List<AliasResolver> resolvers;

    public static final AliasFacade getInstance(@NotNull Project project) {
        if (project == null) {
            AliasFacade.$$$reportNull$$$0(0);
        }
        return (AliasFacade)ServiceManager.getService((Project)project, AliasFacade.class);
    }

    public AliasFacade(Project project) {
        this.project = project;
        this.resolvers = Lists.newArrayList();
        this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.initResolvers();
    }

    private void initResolvers() {
        try {
            Class.forName("com.intellij.spring.model.utils.SpringModelUtils");
            this.registerResolver(AliasResolverFactory.createBeanResolver(this.project));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.registerResolver(AliasResolverFactory.createSingleAliasResolver(this.project));
        this.registerResolver(AliasResolverFactory.createConfigPackageResolver(this.project));
        this.registerResolver(AliasResolverFactory.createAnnotationResolver(this.project));
        this.registerResolver(AliasResolverFactory.createInnerAliasResolver(this.project));
    }

    @NotNull
    public Optional<PsiClass> findPsiClass(@Nullable PsiElement element, @NotNull String shortName) {
        PsiClass clazz;
        if (shortName == null) {
            AliasFacade.$$$reportNull$$$0(1);
        }
        if (null != (clazz = this.javaPsiFacade.findClass(shortName, GlobalSearchScope.allScope((Project)this.project)))) {
            Optional<PsiClass> optional = Optional.of(clazz);
            if (optional == null) {
                AliasFacade.$$$reportNull$$$0(2);
            }
            return optional;
        }
        for (AliasResolver resolver : this.resolvers) {
            for (AliasDesc desc : resolver.getClassAliasDescriptions(element)) {
                if (!shortName.equalsIgnoreCase(desc.getAlias())) continue;
                Optional<PsiClass> optional = Optional.of(desc.getClazz());
                if (optional == null) {
                    AliasFacade.$$$reportNull$$$0(3);
                }
                return optional;
            }
        }
        Optional<PsiClass> optional = Optional.empty();
        if (optional == null) {
            AliasFacade.$$$reportNull$$$0(4);
        }
        return optional;
    }

    @NotNull
    public Collection<AliasDesc> getAliasDescs(@Nullable PsiElement element) {
        ArrayList result = Lists.newArrayList();
        for (AliasResolver resolver : this.resolvers) {
            result.addAll(resolver.getClassAliasDescriptions(element));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AliasFacade.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public Optional<AliasDesc> findAliasDesc(@Nullable PsiClass clazz) {
        if (clazz == null) {
            return Optional.empty();
        }
        for (AliasResolver resolver : this.resolvers) {
            for (AliasDesc desc : resolver.getClassAliasDescriptions((PsiElement)clazz)) {
                if (!clazz.equals(desc.getClazz())) continue;
                return Optional.of(desc);
            }
        }
        return Optional.empty();
    }

    public void registerResolver(@NotNull AliasResolver resolver) {
        if (resolver == null) {
            AliasFacade.$$$reportNull$$$0(6);
        }
        this.resolvers.add(resolver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/wuzhizhan/mybatis/alias/AliasFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/wuzhizhan/mybatis/alias/AliasFacade";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPsiClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasDescs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerResolver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

